{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 27.01.99 - 20:16:39 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  ShellAPI,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Buttons,
  ComCtrls,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMSystem,
  MMUtils,
  MMAbout,
  MMObj,
  MMDSPObj,
  MMWaveIO,
  MMMPType,
  MMMPEG,
  MMDesign,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMSpectr,
  MMHTimer,
  MMSlider,
  MMLEDS,
  MMPanel,
  MMSpin,
  MMLEDLbl,
  MMButton,
  MMWave,
  MMLabel,
  MMHook, MMPitch;

type
  TMainForm = class(TForm)
    OpenDialog: TOpenDialog;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    HiTimer: TMMHiTimer;
    MMPanel2: TMMPanel;
    ButtonPanel: TMMPanel;
    DisplayPanel: TMMPanel;
    MMPanel7: TMMPanel;
    MMLevelScale1: TMMLevelScale;
    digit: TMMLEDDigit;
    MMLevel2: TMMLevel;
    MMLevel1: TMMLevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MMSpectrum1: TMMSpectrum;
    ss1: TMMLEDDigit;
    ss2: TMMLEDDigit;
    mm1: TMMLEDDigit;
    mm2: TMMLEDDigit;
    btnStop: TMMSpeedButton;
    btnPlay: TMMSpeedButton;
    btnPause: TMMSpeedButton;
    btnOpen: TMMSpeedButton;
    btnPrev: TMMSpeedButton;
    btnSkipL: TMMSpeedButton;
    btnSkipR: TMMSpeedButton;
    btnNext: TMMSpeedButton;
    btnClose: TMMSpeedButton;
    btnMenu: TMMSpeedButton;
    btnIncVolume: TMMSpeedButton;
    btnDecVolume: TMMSpeedButton;
    Bevel1: TBevel;
    btnPlayList: TMMSpeedButton;
    Gauge: TMMLevel;
    Bevel2: TBevel;
    ledMode: TMMLEDMode;
    ledRate: TMMLEDPanel;
    Label18: TLabel;
    lblBitRate: TLabel;
    ledBitRate: TMMLEDPanel;
    lblLayer: TLabel;
    lblLayer2: TLabel;
    lblFile: TMMLEDLABEL;
    PopupMenu: TPopupMenu;
    Preferences1: TMenuItem;
    N1: TMenuItem;
    Play1: TMenuItem;
    Stop1: TMenuItem;
    Pause1: TMenuItem;
    N2: TMenuItem;
    Previous1: TMenuItem;
    Next1: TMenuItem;
    N3: TMenuItem;
    PlayList1: TMenuItem;
    WaveFile: TMMWaveFile;
    N4: TMenuItem;
    Info1: TMenuItem;
    MMLabel1: TMMLabel;
    ImageEOF: TImage;
    ImageState: TImage;
    MPEGFile: TMMMPEGFile;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure HiTimerTimer(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnSkipLClick(Sender: TObject);
    procedure btnSkipRClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure btnDecVolumeClick(Sender: TObject);
    procedure btnIncVolumeClick(Sender: TObject);
    procedure btnPlayListClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);

    procedure MMPanelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
    procedure GaugeMouseDown(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnMenuClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure PreferencesClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure WaveOutPause(Sender: TObject);
    procedure WaveOutRestart(Sender: TObject);
  public
    oMin, oSec: Word;
    Dragging: Boolean;
    DragStart: TPoint;

    Seeking: Boolean;
    OldTime,CurTime: Longint;

    PlayListName: TFileName;
    PlayList : TStringList;
    PlayIndex: integer;
    IncPlayList: Boolean;

    DisplayColor: TColor;

    TimeCnt : Longint;

    procedure LoadImage(Image: TImage; Name: PChar);
    procedure DrawTime(Time: Longint);
    procedure SetFileParams;
    function  LoadFile(FileName: TFileName): Boolean;
    function  AddFile(FileName: TFileName): Boolean;
    procedure SelectFile(index: integer);
    procedure WMNCHitTest(var Msg: TWMNCHitTest); message WM_NCHitTest;
    procedure WMDropFiles(var Msg: TMessage); message WM_DropFiles;
    procedure LoadSettings;
    procedure SaveSettings;

    procedure DrawLevelBar(Sender: TObject; DIB: TMMDIBCanvas; Rect: TRect; nSpots,Peak: integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
{$R IMAGE.RES}

uses unit2,unit3;

const
    REGBASENAME =  'Software\SwiftSoft\MPEGPlay';

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WMNCHitTest(var Msg: TWMNCHitTest);
begin
   inherited;                       { is the click in the client area?   }
   if (Msg.Result = htClient) then  { if so, make Windows think it's     }
       Msg.Result := htCaption;     { on the caption bar.                }
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.LoadImage(Image: TImage; Name: PChar);
begin
   with Image.Picture do
   begin
      { load the bitmap }
      Bitmap.Handle := LoadBitmap(hInstance,Name);
      { change the black/white resource to a colored bitmap }
      ChangeColors(Bitmap,False,DisplayColor,clBlack,clBlack);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.LoadSettings;
var
   L,T: integer;
begin
   try
      L := (Screen.Width-Width) div 2;
      T := (Screen.Height-Height) div 2;
      Left := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Left', L);
      Top  := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Top', T);
      WaveOut.NumBuffers := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Buffers', WaveOut.NumBuffers);
      WaveOut.BufferSize := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'BufferSize', WaveOut.BufferSize);
      WaveOut.DeviceID := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'DeviceID', WaveOut.DeviceID);
      WaveOut.CallBackMode := GetFromRegistry(HKEY_CURRENT_USER, REGBASENAME, 'CBMode', WaveOut.CallBackMode);
   except
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SaveSettings;
begin
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Left', Left);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Top', Top);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'Buffers', WaveOut.NumBuffers);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'BufferSize', WaveOut.BufferSize);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'DeviceID', WaveOut.DeviceID);
   SaveInRegistry(HKEY_CURRENT_USER, REGBASENAME, 'CBMode', WaveOut.CallBackMode);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   MMLevel1.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR1');
   MMLevel2.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR1');
   MMSpectrum1.DIBCanvas.BackGroundBitmap.LoadFromResourceName(hInstance,'BM_BAR2');
   MMLevel1.DIBCanvas.PaletteRealize := True;
   MMLevel2.DIBCanvas.PaletteRealize := True;
   MMSpectrum1.DIBCanvas.PaletteRealize := True;

   DragAcceptFiles(Handle,True);
   PlayListName := 'noname.m3u';
   PlayList  := TStringList.Create;
   PlayIndex := 0;

   DisplayColor := clLime;
   LoadImage(ImageEOF,'BM_EOF');
   LoadImage(ImageState,'BM_PLAY');

   LoadSettings;

   MMLevel1.OnDrawBar := DrawLevelBar;
   MMLevel2.OnDrawBar := DrawLevelBar;
   MMSpectrum1.OnDrawBar := DrawLevelBar;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
   PlayList.Free;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   IncPlayList := False;
   WaveOut.Close;

   SaveSettings;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   if (ParamStr(1) <> '') then
      if LoadFile(ParamStr(1)) then
      begin
         btnPlayClick(nil);
      end
      else MessageDlg(ParamStr(1)+' is not a valid Audiofile',mtError, [mbOK],0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WMDropFiles(var Msg: TMessage);
var
   i,cnt: integer;
   Buf: array[0..255]of Char;

begin
   try
      cnt := DragQueryFile(Msg.wParam,$FFFFFFFF,@Buf,255);
      if (cnt > 0) then
      begin
         IncPlayList := False;
         WaveOut.Stop;
         PlayList.Clear;
         for i := 0 to cnt-1 do
         begin
            DragQueryFile(Msg.wParam,i,@Buf,255);
            if not AddFile(StrPas(Buf)) then
               MessageDlg(StrPas(Buf)+' is not a valid Audiofile',mtError, [mbOK],0);
         end;

         PlayIndex := 0;
         SelectFile(0);
         if (PlayList.Count > 0) then btnPlayClick(nil);
      end;

   finally
      DragFinish(Msg.wParam);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.DrawTime(Time: Longint);
Var
   Hour, Min, Sec, MSec: Word;

begin
   { Display the "Time" }
   TimeDecode(Time, Hour, Min, Sec, MSec);

   if (oSec <> Sec) then
   begin
      ss1.Value := Sec;
      oSec := Sec;
   end;

   if (oMin <> Min) then
   begin
      mm1.Value := Min;
      oMin := Min;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SetFileParams;
begin
   if not MpegFile.Empty then
   with MpegFile do
   begin
      ss1.Enabled  := True;
      ss2.Enabled  := True;
      mm1.Enabled  := True;
      mm2.Enabled  := True;
      digit.Enabled:= True;

      lblFile.Caption := IntToStr(PlayIndex+1)+':'+UpperCase(ExtractFileName(Filename));
      ledRate.Value   := PlaybackRate div 1000;
      ledRate.Enabled := True;

      lblLayer.Visible  := True;
      lblLayer2.Visible := True;
      case Layer of
          1: lblLayer2.Caption := 'I';
          2: lblLayer2.Caption := 'II';
          3: lblLayer2.Caption := 'III';
      end;

      if (Mode = smJointStereo) or (Mode = smStereo) then
         ledMode.Mode := mStereo
      else
         ledMode.Mode := mMono;
      ledMode.Enabled := True;

      ledBitRate.Value := BitRate;
      ledBitRate.Enabled := True;
      lblBitRate.Caption := 'KBit/s';
   end
   else if not WaveFile.Wave.Empty then
   with WaveFile.Wave do
   begin
      ss1.Enabled  := True;
      ss2.Enabled  := True;
      mm1.Enabled  := True;
      mm2.Enabled  := True;
      digit.Enabled:= True;

      lblFile.Caption := IntToStr(PlayIndex+1)+':'+UpperCase(ExtractFileName(Filename));
      ledRate.Value   := SampleRate div 1000;
      ledRate.Enabled := True;

      lblLayer.Visible  := False;
      lblLayer2.Visible := False;

      ledMode.Mode := Mode;
      ledMode.Enabled := True;

      ledBitRate.Value := BitLength;
      ledBitRate.Enabled := True;
      lblBitRate.Caption := 'Bit';
   end
   else
   begin
      ss1.Enabled  := False;
      ss2.Enabled  := False;
      mm1.Enabled  := False;
      mm2.Enabled  := False;
      digit.Enabled:= False;

      lblFile.Caption   := 'NO FILE';
      ledRate.Enabled   := False;
      lblLayer.Visible  := False;
      lblLayer2.Visible := False;
      ledMode.Enabled   := False;
      ledBitRate.Enabled:= False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.HiTimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   MMConnector1.Trigger;

   inc(TimeCnt);

   if (TimeCnt mod 5 = 0) and (wosPlay in Waveout.State) and not Seeking then
   begin
      Time := WaveOut.Position;
      inc(CurTime,Time-OldTime);
      DrawTime(CurTime);
      OldTime := Time;

      if not MpegFile.Empty then
      begin
         Gauge.Value := MulDiv(MpegFile.Position, 100, MpegFile.Frames);
         ImageEOF.Visible := MpegFile.Position >= MpegFile.Frames;
      end
      else
      begin
         Gauge.Value := MulDiv(WaveFile.Wave.Position, 100, WaveFile.Wave.DataSize);
         ImageEOF.Visible := WaveFile.Wave.Position >= WaveFile.Wave.DataSize;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   TimeCnt := 0;
   HiTimer.Enabled := True;
   LoadImage(ImageState,'BM_PLAY');
   ImageState.Visible := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   HiTimer.Enabled := False;
   WaveOut.Close;
   Seeking := False;
   DrawTime(0);
   Gauge.Value := 0;
   ImageEOF.Visible := False;
   ImageState.Visible := False;

   if IncPlayList then
   begin
      if (PlayIndex < PlayList.Count-1) then
      begin
         inc(PlayIndex);
         SelectFile(PlayIndex);
         WaveOut.Start;
      end
      else
      begin
         PlayIndex := 0;
         SelectFile(PlayIndex);
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutPause(Sender: TObject);
begin
   LoadImage(ImageState,'BM_PAUSE');
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutRestart(Sender: TObject);
begin
   LoadImage(ImageState,'BM_PLAY');
end;

{-- TMainForm -----------------------------------------------------------}
function TMainForm.LoadFile(FileName: TFileName): Boolean;
begin
   Result := False;
   if (FileName <> '') and FileExists(FileName) then
   begin
      PlayIndex := 0;
      PlayList.Clear;
      MpegFile.FileName := '';
      WaveFile.Wave.FileName := '';

      if IsMpegFile(FileName) or wioIsWaveFile(FileName, RIFF_FILE) then
      begin
         PlayListName := 'noname.m3u';
         PlayList.Add(FileName);
      end
      else
      begin
         PlayListName := FileName;
         LoadPlayList(FileName,PlayList);
      end;

      Result := (PlayList.Count > 0);

      SelectFile(0);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
function TMainForm.AddFile(FileName: TFileName): Boolean;
begin
   Result := False;
   if (FileName <> '') and FileExists(FileName) then
   begin
      if IsMpegFile(FileName) or wioIsWaveFile(FileName, RIFF_FILE) then
      begin
         PlayList.Add(FileName);
         Result := True;
      end
      else
      begin
         Result := LoadPlayList(FileName,PlayList);
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SelectFile(index: integer);
var
   FileName: TFileName;
begin
   MpegFile.FileName := '';
   WaveFile.Wave.FileName := '';

   if (index >= 0) and (index < PlayList.Count) then
   begin
      FileName := PlayList[index];
      if (FileName <> '') and FileExists(FileName) then
      begin
         if IsMpegFile(FileName) then
         begin
            MpegFile.FileName := FileName;
            WaveOut.Input := MpegFile;
         end
         else if wioIsWaveFile(FileName, RIFF_FILE) then
         begin
            WaveFile.Wave.FileName := FileName;
            WaveOut.Input := WaveFile;
         end
      end;
      CurTime := 0;
      OldTime := 0;
   end;
   SetFileParams;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.PopupMenuPopup(Sender: TObject);
begin
   { adjust menu entrys }
   PopupMenu.Items[6].Enabled := PlayList.Count > 1;
   PopupMenu.Items[7].Enabled := PlayList.Count > 1;

   if (wosPlay in WaveOut.State) then
   begin
      PopupMenu.Items[0].Enabled := False;
      PopupMenu.Items[2].Caption := '&Restart';
      PopupMenu.Items[3].Enabled := True;
      PopupMenu.Items[4].Enabled := True;
   end
   else
   begin
      PopupMenu.Items[0].Enabled := True;
      PopupMenu.Items[2].Caption := '&Play';
      PopupMenu.Items[3].Enabled := False;
      PopupMenu.Items[4].Enabled := False;
   end;

   if (wosPause in WaveOut.State) then
      PopupMenu.Items[3].Caption := '&UnPause'
   else
      PopupMenu.Items[3].Caption := '&Pause';
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.PreferencesClick(Sender: TObject);
begin
   with TPreferencesForm.Create(Self) do
   try
      ShowModal;
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnOpenClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      IncPlayList := False;
      WaveOut.Stop;

      if not LoadFile(OpenDialog.FileName) then
         MessageDlg('This is not a valid Audiofile',mtWarning, [mbOK],0);

      SetFileParams;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnCloseClick(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnMenuClick(Sender: TObject);
var
   P: TPoint;
begin
   P := ButtonPanel.ClientToScreen(Point(btnMenu.Left,btnMenu.Top+btnMenu.Height));
   PopupMenu.Popup(P.X,P.Y);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
begin
   if (PlayList.Count = 0) then
   begin
      btnOpenClick(nil);
      Refresh;
   end;

   IncPlayList := False;

   if (PlayList.Count > 0) then
   begin
      if not (wosPlay in WaveOut.State) then
      begin
         SelectFile(PlayIndex);
         WaveOut.Start;
      end
      else if (wosPause in WaveOut.State) then
         WaveOut.Restart
      else
      begin
         WaveOut.Stop;
         WaveOut.Start;
      end;
   end;
   IncPlayList := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      if (wosPause in WaveOut.State) then
         WaveOut.Restart
      else
         WaveOut.Pause;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   IncPlayList := False;
   WaveOut.Stop;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPrevClick(Sender: TObject);
begin
   IncPlayList := False;

   if (PlayIndex > 0) then
   begin
      dec(PlayIndex);

      if (wosPlay in WaveOut.State) then
      begin
         WaveOut.Stop;
         SelectFile(PlayIndex);
         WaveOut.Start;
      end
      else SelectFile(PlayIndex);
   end;
   IncPlayList := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnNextClick(Sender: TObject);
begin
   IncPlayList := False;

   if (PlayIndex < PlayList.Count-1) then
   begin
      inc(PlayIndex);

      if (wosPlay in WaveOut.State) then
      begin
         WaveOut.Stop;
         SelectFile(PlayIndex);
         WaveOut.Start;
      end
      else SelectFile(PlayIndex);
   end;
   IncPlayList := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.GaugeMouseDown(Sender: TObject; Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
var
   aPos: Longint;

begin
   if (wosOpen in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
          with Gauge do
          aPos := MulDiv(X-BevelExtend,MpegFile.Frames,(Width-2*BevelExtend)-1);
          if aPos >= MpegFile.Frames then
          begin
             WaveOut.Stop;
             exit;
          end
          else
          begin
             MpegFile.Position := aPos;
             CurTime := MpegFile.Position*MpegFile.TimePerFrame;
          end;
      end
      else
      begin
          with Gauge do
          aPos := MulDiv(X-BevelExtend,WaveFile.Wave.DataSize,(Width-2*BevelExtend)-1);
          if aPos > WaveFile.Wave.DataSize then
          begin
             WaveOut.Stop;
             exit;
          end
          else
          begin
             WaveFile.Wave.Position := aPos;
             CurTime := WaveFile.Wave.Position;
          end;
      end;
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnSkipLClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
         MpegFile.Position := MpegFile.Position-(5000 div MpegFile.TimePerFrame);
         CurTime := MpegFile.Position*MpegFile.TimePerFrame;
      end
      else
      begin
         WaveFile.Wave.Position := WaveFile.Wave.Position-5000;
         CurTime := WaveFile.Wave.Position;
      end;
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnSkipRClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      if not MpegFile.Empty then
      begin
         if MpegFile.Position+(5000 div MpegFile.TimePerFrame) > MpegFile.Frames then
            WaveOut.Stop;
      end
      else
      begin
         if WaveFile.Wave.Position+5000 > WaveFile.Wave.DataSize then
            WaveOut.Stop;
      end;

      Seeking := True;
      WaveOut.Pause;
      if not MpegFile.Empty then
      begin
         MpegFile.Position := MpegFile.Position+(5000 div MpegFile.TimePerFrame);
         CurTime := MpegFile.Position*MpegFile.TimePerFrame;
      end
      else
      begin
         WaveFile.Wave.Position := WaveFile.Wave.Position+5000;
         CurTime := WaveFile.Wave.Position;
      end;
      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnDecVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Max(L - 5000,0);
      R := Max(R - 5000,0);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnIncVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Min(L + 5000,$FFFF);
      R := Min(R + 5000,$FFFF);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayListClick(Sender: TObject);
var
   wasPlaying: Boolean;
begin
   with TPlayListEditor.Create(Self) do
   try
      if ShowModal = mrOK then
      begin
         IncPlayList := False;
         wasPlaying := (wosPlay in WaveOut.State);
         WaveOut.Stop;
         PlayList.Assign(TempPlayList);
         PlayListName := ListName;
         PlayIndex := 0;
         SelectFile(0);
         if wasPlaying then btnPlayClick(nil);
      end;
      
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then
   begin
      Dragging := True;
      DragStart := TControl(Sender).ClientToScreen(Point(X,Y));
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then Dragging := False;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseMove(Sender: TObject; Shift: TShiftState;
                                     X, Y: Integer);
var
   Diff: TPoint;
begin
   if Dragging then
   begin
      Diff := TControl(Sender).ClientToScreen(Point(X,Y));
      Diff := Point(Diff.X-DragStart.X,Diff.Y-DragStart.Y);
      SetBounds(Left+Diff.X,Top+Diff.Y,Width,Height);
      DragStart.X := DragStart.X+Diff.X;
      DragStart.Y := DragStart.Y+Diff.Y;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Info1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.DrawLevelBar(Sender: TObject; DIB: TMMDIBCanvas; Rect: TRect; nSpots,Peak: integer);
begin
   with DIB,Rect do
   begin
      if Sender = MMSpectrum1 then
      begin
         DIB_CopyDIBBits(MMSpectrum1.DIBCanvas.BackSurface,Left,Bottom-nSpots,Right-Left-1,Bottom,0,Bottom-nSpots);
         DIB_CopyDIBBits(MMSpectrum1.DIBCanvas.BackSurface,Left,Bottom-Peak,Right-Left-1,2,0,Bottom-Peak);
      end
      else if Sender = MMLevel1 then
      begin
         DIB_SetTColor(MMLevel1.Color);
         DIB_Clear;
         DIB_CopyDIBBits(MMLevel1.DIBCanvas.BackSurface,0,Top,2*nSpots,Bottom,0,0);
         DIB_CopyDIBBits(MMLevel1.DIBCanvas.BackSurface,2*Peak-2,Top,2,Bottom,2*Peak,0);
      end
      else
      begin
         DIB_SetTColor(MMLevel2.Color);
         DIB_Clear;
         DIB_CopyDIBBits(MMLevel2.DIBCanvas.BackSurface,0,Top,2*nSpots,Bottom,0,0);
         DIB_CopyDIBBits(MMLevel2.DIBCanvas.BackSurface,2*Peak-2,Top,2,Bottom,2*Peak,0);
      end;
   end;
end;

end.
